/**
 * \file               smac_802_15_4_shim.c        
 *
 * \version 1.0
 * first version
 *
 * \date               04-26-2007
 *
 * \author             mtalreja
 *
 * \warning           
 * 
 * \note              
 *
 * \review             
 * 
 * \bug                
 *
 **/


#include "hprfgw_config.h"
#include "smac_802_15_4_shim.h"
#include "hprfgw_rfPublicConst.h"
#include "smac_simple_phy.h"
#include "smac_app.h"
#include "smac_pub_def.h"
#include "smac_simple_mac.h"
//#include "hprfgw_rfSharedDefs.h"
//#include "hprfgw_rfSlaveIntToHost.h"
//#include "hprfgw_rfSlaveIntToRfApp.h"


// Globals
//Rf_Smac_802_PHYParams_struct Rf_Smac_802_PHYParams;
//Rf_Smac_802_PIB_struct       Rf_Smac_802_PIB;
//Rf_Smac_Shim_Struct          Rf_Smac_Shim;


#define SMAC_PAYLOAD_MAXSIZE                          (128)
#define SMAC_802_15_4_SHIM_NWKMSG_QUEUE_SIZE          (1*1024*(sizeof(nwkMessage_t) + SMAC_PAYLOAD_MAXSIZE))
#define SMAC_802_15_4_SHIM_MCPSTONWKMSG_QUEUE_SIZE    (1*1024*(sizeof(mcpsToNwkMessage_t)+ SMAC_PAYLOAD_MAXSIZE))
#define SMAC_802_15_4_SHIM_ASPTONWKMSG_QUEUE_SIZE     (1*1024*(sizeof(aspToAppMsg_t)+ SMAC_PAYLOAD_MAXSIZE))

//Prototype
void SmacShimTask(UINT32 context);

/**
 *
 * \date        04-26-2007
 *
 * \author      mtalreja
 *
 * \brief       Init_Smac_802_15_4_Shim
 *
 * \detail      Initialize all the data structures needed by the simulation interface
 *
 * \return      What is returned
 *
 * \retval      
 *
 * \param void 
 */
void Init_Smac_802_15_4_Shim(void)
{
#if defined (OS_NUCLEUS)
  void * pointer;
#elif defined (OS_WINCE)
	MSGQUEUEOPTIONS sMsgQueueOpt;
#endif
  unsigned int rand_seed;
  size_t messageSize;
  // MNT - 7/5/2007 - Initialize the random seed with the UID
  rand_seed = (Rf_Smac_802_PHYParams.deviceExtendedAddress[0] )| 
                  (Rf_Smac_802_PHYParams.deviceExtendedAddress[1] << 8 )| 
                  (Rf_Smac_802_PHYParams.deviceExtendedAddress[2] << 16 )|
                  (Rf_Smac_802_PHYParams.deviceExtendedAddress[3] << 24 );
  srand(rand_seed);

  // MNT - 7/5/2007 - Initialize the backoff exponent and the max number of csma backoffs
  Rf_Smac_802_PIB.minBE = SMAC_802_PIB_MINBE_DEFAULT;
  Rf_Smac_802_PIB.maxCSMABackoffs = SMAC_802_PIB_MAXCSMABOFF_DEFAULT;

#if defined (OS_NUCLEUS)
  if (NU_Allocate_Memory(&System_Memory, &pointer, SMAC_802_15_4_SHIM_NWKMSG_QUEUE_SIZE, NU_NO_SUSPEND) != NU_SUCCESS)
  {
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // allocate memory for MlmeNwkInputQueue
    
  if (NU_Create_Pipe(&Rf_Smac_Shim.MlmeNwkInputQueue, 
                     "RFRXMLNQ", 
                     pointer, 
                     SMAC_802_15_4_SHIM_NWKMSG_QUEUE_SIZE,
                     NU_VARIABLE_SIZE, 
                     SMAC_PAYLOAD_MAXSIZE+sizeof(nwkMessage_t), 
                     NU_FIFO) != NU_SUCCESS)
  {
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // Create pipe for MlmeNwkInputQueue



  if (NU_Allocate_Memory(&System_Memory, &pointer, SMAC_802_15_4_SHIM_MCPSTONWKMSG_QUEUE_SIZE, NU_NO_SUSPEND) != NU_SUCCESS)
  {
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // allocate memory for McpsNwkInputQueue
    
  if (NU_Create_Pipe(&Rf_Smac_Shim.McpsNwkInputQueue, 
                     "RFRXMCNQ", 
                     pointer, 
                     SMAC_802_15_4_SHIM_MCPSTONWKMSG_QUEUE_SIZE,
                     NU_VARIABLE_SIZE, 
                     SMAC_PAYLOAD_MAXSIZE+sizeof(mcpsToNwkMessage_t), 
                     NU_FIFO) != NU_SUCCESS)
  {
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // Create pipe for McpsNwkInputQueue


  if (NU_Allocate_Memory(&System_Memory, &pointer, SMAC_802_15_4_SHIM_ASPTONWKMSG_QUEUE_SIZE, NU_NO_SUSPEND) != NU_SUCCESS)
  {
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // allocate memory for AspNwkInputQueue
    
  if (NU_Create_Pipe(&Rf_Smac_Shim.AspNwkInputQueue, 
                     "RFRXASNQ", 
                     pointer, 
                     SMAC_802_15_4_SHIM_ASPTONWKMSG_QUEUE_SIZE,
                     NU_VARIABLE_SIZE, 
                     SMAC_PAYLOAD_MAXSIZE+sizeof(aspToAppMsg_t), 
                     NU_FIFO) != NU_SUCCESS)
  {
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // Create pipe for AspNwkInputQueue


  //Create and start the task to monitor incoming data
  if (NU_Create_Task(&Rf_Smac_Shim.task, "TRFSHIM", SmacShimTask, 0,
      NU_NULL, Rf_Smac_Shim.stack, sizeof(Rf_Smac_Shim.stack),
      SMAC_SHIM_TASK_PRIORITY, 0, NU_PREEMPT, NU_START) != NU_SUCCESS)
  {
    DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
#elif defined (OS_WINCE)
  //Set options for the message queue - once for all the queues created below
  sMsgQueueOpt.dwSize = sizeof(sMsgQueueOpt);		//Size of the structure in bytes
  sMsgQueueOpt.dwFlags = 0;						    //Describes the behavior of the message queue
  sMsgQueueOpt.dwMaxMessages = 0;					//No limit on number of messages to queue at any one time, set to zero

  // Message size, Maximum number of bytes in each message
  sMsgQueueOpt.cbMaxMessage = (SMAC_PAYLOAD_MAXSIZE+sizeof(nwkMessage_t)); 
  // Write handle to queue.
  sMsgQueueOpt.bReadAccess = FALSE;
  Rf_Smac_Shim.hWriteMlmeNwkInputQueue = CreateMsgQueue(TEXT("RFRXMLNQ"),  &sMsgQueueOpt);
  // Read handle to queue
  sMsgQueueOpt.bReadAccess = TRUE;
  Rf_Smac_Shim.hReadMlmeNwkInputQueue = CreateMsgQueue(TEXT("RFRXMLNQ"),  &sMsgQueueOpt);
  if (NULL == Rf_Smac_Shim.hWriteMlmeNwkInputQueue || NULL == Rf_Smac_Shim.hReadMlmeNwkInputQueue)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Init_Smac_Shim: Fail create MLME MsgQ");
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // Create pipe for MlmeNwkInputQueue

  // Message size, Maximum number of bytes in each message
  sMsgQueueOpt.cbMaxMessage = (SMAC_PAYLOAD_MAXSIZE+sizeof(mcpsToNwkMessage_t)); 
  // Write handle to queue.
  sMsgQueueOpt.bReadAccess = FALSE;
  Rf_Smac_Shim.hWriteMcpsNwkInputQueue = CreateMsgQueue(TEXT("RFRXMCNQ"),  &sMsgQueueOpt);
  // Read handle to queue
  sMsgQueueOpt.bReadAccess = TRUE;
  Rf_Smac_Shim.hReadMcpsNwkInputQueue = CreateMsgQueue(TEXT("RFRXMCNQ"),  &sMsgQueueOpt);
  if (NULL == Rf_Smac_Shim.hWriteMcpsNwkInputQueue || NULL == Rf_Smac_Shim.hReadMcpsNwkInputQueue)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Init_Smac_Shim: Fail create MCPS MsgQ");
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // Create pipe for MlmeNwkInputQueue

  // Message size, Maximum number of bytes in each message
  sMsgQueueOpt.cbMaxMessage = (SMAC_PAYLOAD_MAXSIZE+sizeof(aspToAppMsg_t)); 
  // Write handle to queue.
  sMsgQueueOpt.bReadAccess = FALSE;
  Rf_Smac_Shim.hWriteAspNwkInputQueue = CreateMsgQueue(TEXT("RFRXASNQ"),  &sMsgQueueOpt);
  // Read handle to queue
  sMsgQueueOpt.bReadAccess = TRUE;
  Rf_Smac_Shim.hReadAspNwkInputQueue = CreateMsgQueue(TEXT("RFRXASNQ"),  &sMsgQueueOpt);
  if (NULL == Rf_Smac_Shim.hWriteAspNwkInputQueue || NULL == Rf_Smac_Shim.hReadAspNwkInputQueue)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Init_Smac_Shim: Fail create ASP MsgQ");
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }

  //Create and start the task to monitor incoming data
  Rf_Smac_Shim.task = CreateThread(NULL, 0, SmacShimTask, pHPRDevice, 0, NULL);
  if (NULL == Rf_Smac_Shim.task)
  {
	DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Init_Smac_Shim: Fail create thread");
	DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
  // Set thread priority
  CeSetThreadPriority(Rf_Smac_Shim.task, SMAC_SHIM_TASK_PRIORITY);

#endif
  messageSize = SMAC_PAYLOAD_MAXSIZE+sizeof(nwkMessage_t);
  DmConsolePrintf("%s messageSize = %u\n", __FUNCTION__, messageSize);
  Rf_Smac_Shim.hMlmeNwkInputQueue = OsQueueCreate(SMAC_802_15_4_SHIM_NWKMSG_QUEUE_SIZE/messageSize, messageSize);
  if (!Rf_Smac_Shim.hMlmeNwkInputQueue)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Init_Smac_Shim: Fail create MLME MsgQ");
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // Create pipe for MlmeNwkInputQueue

  messageSize = SMAC_PAYLOAD_MAXSIZE+sizeof(mcpsToNwkMessage_t);
  // This is the queue that fills up.
  DmConsolePrintf("%s messageSize = %u\n", __FUNCTION__, messageSize);
  Rf_Smac_Shim.hMcpsNwkInputQueue = OsQueueCreate(SMAC_802_15_4_SHIM_MCPSTONWKMSG_QUEUE_SIZE/messageSize, messageSize);
  if (!Rf_Smac_Shim.hMcpsNwkInputQueue)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Init_Smac_Shim: Fail create MCPS MsgQ");
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // Create pipe for McpsNwkInputQueue

  messageSize = SMAC_PAYLOAD_MAXSIZE+sizeof(aspToAppMsg_t);
  Rf_Smac_Shim.hAspNwkInputQueue =
		  OsQueueCreate(SMAC_802_15_4_SHIM_ASPTONWKMSG_QUEUE_SIZE/messageSize, messageSize);
  if (!Rf_Smac_Shim.hAspNwkInputQueue)
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Init_Smac_Shim: Fail create ASP MsgQ");
      DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
  Rf_Smac_Shim.task = OsCreateNamedAdvTaskPri(SmacShimTask, 0, 0, SMAC_SHIM_TASK_PRIORITY, "TRFSHIM");
  //Create and start the task to monitor incoming data
  if(!Rf_Smac_Shim.task)
  {
	  DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
}



/**
 *
 * \date        04-26-2007
 *
 * \author      mtalreja
 *
 * \brief       SmacShimTask
 *
 * \detail      This task suspends on the incoming SMAC queue and pushes messages
 *               into the 
 *
 * \return      What is returned
 *
 * \retval      
 *
 * \param argc 
 * \param *argv 
 */
#if defined (OS_NUCLEUS)
void SmacShimTask(unsigned long argc, void *argv )
#elif defined (OS_WINCE)
DWORD SmacShimTask(VOID* pContext )
#endif
void SmacShimTask(UINT32 context)
{
  SMAC_TO_Rf_802_15_MAC_Frame_struct recvPkt;
  //Rf_802_15_MAC_Data_Frame_struct recvPkt;
  mcpsToNwkMessage_t *mcpsData;
  //mcpsDataInd_t mcpsData; 
  INT32 actualPktSize;
  UINT32 dataInPktSize;
  const INT32 minActualPktSize = sizeof(Rf_802_15_MAC_Data_FrameHdr_struct) + SMAC_TO_Rf_802_15_MAC_Frame_HDRSIZE;

  //void * dataRecvd;
#if defined (OS_WINCE)
  DWORD dwFlags = 0;
#endif

  memset(&recvPkt, 0, sizeof(SMAC_TO_Rf_802_15_MAC_Frame_struct));
  actualPktSize=0;

  /* TODO: Figure out what StartupWait was doing. */
  //RFIntHostApp.pF_StartupWait();

  // Allocate memory for a new buffer and copy data received into it - this will never be freed
  mcpsData = MSG_Alloc(SMAC_MAXPACKETSIZE + sizeof(mcpsToNwkMessage_t));

#if defined (OS_WINCE)
	DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "\r\nSmacShimTask: Running!");
#endif

  for (;;)
  {
    // Wait till we get a message in the input queue
#if defined (OS_NUCLEUS)
    if (NU_Receive_From_Pipe(&TxRxTask.fromRFPipe,
                       &recvPkt,
                       sizeof(SMAC_TO_Rf_802_15_MAC_Frame_struct),
                       &actualPktSize,
                       NU_SUSPEND) != NU_SUCCESS)
	{
      DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "SMACSHIMTASK: Error receiving from pipe\r\n");
     
    } // if (NU_Receive_From_Pipe(TxRxTask.fromRFPipe
#elif defined (OS_WINCE)
	if (!ReadMsgQueue(TxRxTask.hReadHandleFromRFPipe, (void*)&recvPkt, sizeof(SMAC_TO_Rf_802_15_MAC_Frame_struct), &actualPktSize, OS_SUSPEND, &dwFlags))
	{
		DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "SMACSHIMTASK: Error receiving from pipe: %d", GetLastError());
    } // if (!ReadMsgQueue(TxRxTask.hReadHandleFromRFPipe
#endif
    actualPktSize = OsDequeueBytesWait(TxRxTask.hHandleFromRFPipe, (void*)&recvPkt,
            sizeof(SMAC_TO_Rf_802_15_MAC_Frame_struct), OS_WAIT_FOREVER);
    if(actualPktSize < minActualPktSize) {
        if(actualPktSize <= 0) {
            DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "SMACSHIMTASK: Error receiving from pipe\n");
        }
        else {
            DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "SMACSHIMTASK: data from pipe too small. Received %li bytes.\n", actualPktSize);
        }
	    continue;
	}
    HPRF_QUEUE_DEBUG(DmConsolePrintf("*** %s:%i <--- dequeued %i bytes from FromRFPipe\n", \
            __FUNCTION__, __LINE__, actualPktSize);)

	// MNT - 4/27/2007 - This is for debug only - DO NOT PRINT in final application!!!!
        // MNT - 5/30/2007 - Remove this
        // tag_removeprintf
//      RFIntHostApp.pF_ConsolePrintf("Received: %s\r\n", recvPkt.data);

      // MNT - 6/13/2007 - If RF is disabled, just don't send to any pipe terminate here
      // We should not reach here anyways because the ISR will not put anything in the 
      // pipe. However, if there is something remaining to be processed, it won't be :)
      if (Rf_Smac_802_PIB.rfDisabled == TRUE)
      {
          continue;
      }

	  // PRASAD - need conversion?

      //Create the data indication packet 
      mcpsData->msgType = gMcpsDataInd_c;
      mcpsData->msgData.dataInd.srcAddrMode = RF_802_15_MAC_FC_ADDRMODE_EXT;
      mcpsData->msgData.dataInd.dstAddrMode = RF_802_15_MAC_FC_ADDRMODE_EXT;
      mcpsData->msgData.dataInd.mpduLinkQuality = recvPkt.Lqi;
      memcpy(&mcpsData->msgData.dataInd.srcAddr,  &recvPkt.RfData.header.srcAddr,  sizeof(mcpsData->msgData.dataInd.srcAddr));
      memcpy(&mcpsData->msgData.dataInd.srcPanId, &recvPkt.RfData.header.srcPanId, sizeof(mcpsData->msgData.dataInd.srcPanId));
      memcpy(&mcpsData->msgData.dataInd.dstAddr,  &recvPkt.RfData.header.dstAddr,  sizeof(mcpsData->msgData.dataInd.dstAddr));
      memcpy(&mcpsData->msgData.dataInd.dstPanId, &recvPkt.RfData.header.dstPanId, sizeof(mcpsData->msgData.dataInd.dstPanId));
      /// \todo Add LQI from the ground up
      //mcpsData->mpduLinkQuality

      // copy data received into buffer
      dataInPktSize = actualPktSize - minActualPktSize;
      memcpy(&mcpsData->msgData.dataInd.msdu, &recvPkt.RfData.data, dataInPktSize);
      mcpsData->msgData.dataInd.msduLength = (UINT8)dataInPktSize;
      
      //Send the data to to the MCPSNWQ queue
#if defined (OS_NUCLEUS)
      MSG_Queue(&Rf_Smac_Shim.McpsNwkInputQueue, 
                mcpsData, 
                actualPktSize - sizeof(Rf_802_15_MAC_Data_FrameHdr_struct) + sizeof(mcpsToNwkMessage_t));
#elif defined (OS_WINCE)
	  MSG_Queue(Rf_Smac_Shim.hWriteMcpsNwkInputQueue,
                mcpsData, 
                actualPktSize - sizeof(Rf_802_15_MAC_Data_FrameHdr_struct) + sizeof(mcpsToNwkMessage_t));
#endif
	  HPRF_QUEUE_DEBUG(DmConsolePrintf("----- %s:%i ----- queueing packet size %lu to mcpsNwkInputQueue\n", \
	          __FUNCTION__, __LINE__, actualPktSize - sizeof(Rf_802_15_MAC_Data_FrameHdr_struct) + sizeof(mcpsToNwkMessage_t));)
      MSG_Queue(Rf_Smac_Shim.hMcpsNwkInputQueue,
                mcpsData,
                actualPktSize - sizeof(Rf_802_15_MAC_Data_FrameHdr_struct) + sizeof(mcpsToNwkMessage_t)); 
  } // for (;;)
#if defined (OS_WINCE)
  return 0;
#endif

}



// Message Handling Primitives

/**
 *
 * \date        04-26-2007
 *
 * \author      mtalreja
 *
 * \brief       Title
 *
 * \detail      Allocate message and throw an error if not possible
 *
 * \return      Pointer to the memory allocated
 *
 * \retval      
 *
 * \param size 
 */
void * MSG_Alloc(UINT16 size)
{
    void * pointer;

#if defined (OS_NUCLEUS)
    if (NU_Allocate_Memory(&System_Memory, &pointer, size, NU_NO_SUSPEND) != NU_SUCCESS)
    {
        //For now just reboot after printing a message. Decide how to handle this.
        // This should never happen
        DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Could not allocate memory for a message\r\n");
        DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
	} // allocate memory from the System

#elif defined (OS_WINCE)
	//pointer = (void *)HeapAlloc(hprSystemMemoryPool, LPTR, (UINT)size);
	pointer = (void*) LocalAlloc(LPTR, (UINT)size);
	if (NULL == pointer)
	{
        //For now just reboot after printing a message. Decide how to handle this.
        // This should never happen
		DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_Alloc: Could not alloc mem for a msg");
        DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
	}
#endif
	pointer = OsAllocMemory(size);
	if (NULL == pointer)
	{
        //For now just reboot after printing a message. Decide how to handle this.
        // This should never happen
		DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_Alloc: Could not alloc mem for a msg");
        DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
	}
    return pointer;
} // MSG_Alloc




/**
 *
 * \date        04-26-2007
 *
 * \author      mtalreja
 *
 * \brief       MSG_Pending
 *
 * \detail      Indicates if there is a message in a particular queue
 *              The way this is being used is very inefficient - Look at ways of eliminating
 *              this call and just suspending on the pipe
 *
 * \return      BOOL
 *
 * \retval      
 *
 * \param queue 
 * \return 
 */
#if defined (OS_NUCLEUS)
BOOL MSG_Pending(NU_PIPE * pipe)
#elif defined (OS_WINCE)
BOOL MSG_Pending(HANDLE hQueueHandle)
#endif
BOOL MSG_Pending(DM_RESOURCE_HANDLE hQueueHandle)
{
#if defined (OS_NUCLEUS)
  CHAR pipe_name[8];
  VOID *start_address;
  UNSIGNED pipe_size;
  UNSIGNED available;
  UNSIGNED messages;
  OPTION message_type;
  UNSIGNED message_size;
  OPTION suspend_type;
  UNSIGNED tasks_suspended;
  NU_TASK *first_task;
  STATUS status;

  status = NU_Pipe_Information(pipe, pipe_name, &start_address,
                                &pipe_size, &available, &messages,
                                &message_type, &message_size,
                                &suspend_type, &tasks_suspended,
                                &first_task);
#elif defined (OS_WINCE)
	UNSIGNED messages;
	MSGQUEUEINFO sMsgQueueInfo;
	
	// Size needs to be initialized it seems (found in website). Document doesn't say that.
	sMsgQueueInfo.dwSize = sizeof (MSGQUEUEINFO);

	if (GetMsgQueueInfo (hQueueHandle, &sMsgQueueInfo) == TRUE)
	{
		// No of message currently in queue
		messages = (UNSIGNED)sMsgQueueInfo.dwCurrentMessages;
	}
	else
	{
		messages = 0;
		DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_Pending: Err: %d, %d", GetLastError(), hQueueHandle);
	}
#endif
	UNSIGNED messages;

	messages = OsGetQueueCount(hQueueHandle);
	if (messages > 0)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}



/**
 *
 * \date        04-26-2007
 *
 * \author      mtalreja
 *
 * \brief       MSG_DeQueue
 *
 * \detail      Get a message from a queue. Returns NULL if no messages in queue.
 *              This function allocates memory for the message received. The calling
 *              function MUST free this memory
 *
 * \return      A pointer to the message allocated
 *
 * \retval      
 *
 * \param pipe 
 */
#if defined (OS_NUCLEUS)
void * MSG_DeQueue(NU_PIPE * pipe)
#elif defined (OS_WINCE)
void * MSG_DeQueue(HANDLE pipe)
#endif
void* MSG_DeQueue(DM_RESOURCE_HANDLE pipe)
{
  toNwkMessage_t * retPtr;
#if defined(OS_NUCLEUS) || defined(OS_WINCE)
  UINT32 actualSize;
#endif

#if defined (OS_NUCLEUS)
  STATUS status;

  // MNT - 5/9/2007 - Should we switch over to MSG_Alloc over here
  /// \review
  if (NU_Allocate_Memory(&System_Memory, &retPtr, sizeof(toFromNwkMessage_t) + SMAC_MAXPACKETSIZE, NU_NO_SUSPEND) != NU_SUCCESS)
  {
    // MNT - 4/26/2007 - Figure out how to report an error here. For now just reboot
    /// \todo - Handle the error correctly over here
    DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_Dequeue: Could not allocate message when dequeuing\r\n");
    DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // allocate memory for toNwkMessage_t

  status = NU_Receive_From_Pipe(pipe, 
    retPtr, 
    sizeof(toNwkMessage_t), 
    &actualSize,
    NU_NO_SUSPEND) ;

  if (status != NU_SUCCESS)
  {
    /// \todo - Handle the error correctly over here
	DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_Dequeue: No data received from pipe: 0x%x\r\n", status);
    return NULL;
	//DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  } // if receive from pipe

#elif defined (OS_WINCE)

  DWORD dwFlags, dwBuffSize;

  // The size is taken from MSG_DeQueue function, to read the messages for all the 3 pipes.
  //retPtr = (void *)HeapAlloc(hprSystemMemoryPool, LPTR, (sizeof(toFromNwkMessage_t) + SMAC_MAXPACKETSIZE));
  dwBuffSize = (sizeof(toFromNwkMessage_t) + SMAC_MAXPACKETSIZE);
  retPtr = LocalAlloc(LPTR, dwBuffSize);
  if (retPtr == NULL)
  {
	// Hopefully this won't happen!!
	DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_DeQueue: Could not allocate memory!");
	DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
  if (!ReadMsgQueue(pipe, (void*)retPtr, dwBuffSize, &actualSize, OS_NO_SUSPEND, &dwFlags))
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_Dequeue: No data received from pipe: %d", GetLastError());
	  //DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "toFromNwkMessage_t: %d, toNwkMessage_t: %d, actualSize: %d",(sizeof(toFromNwkMessage_t) + SMAC_MAXPACKETSIZE), sizeof(toNwkMessage_t), actualSize);
	  return NULL;
  }
#endif
	INT32 bytes;
	retPtr = OsAllocMemory(sizeof(toFromNwkMessage_t) + SMAC_MAXPACKETSIZE);
	bytes = OsDequeueBytesWait(pipe, retPtr, sizeof(toFromNwkMessage_t) + SMAC_MAXPACKETSIZE, OS_NO_WAIT);
	if (bytes <= 0)
	{
		/// \todo - Handle the error correctly over here
		DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR,
				"MSG_Dequeue: No data received from pipe: %li\r\n", bytes);
		return NULL;
		//DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
	} // if receive from pipe
	return retPtr;
}





/**
 *
 * \date        04-26-2007
 *
 * \author      mtalreja
 *
 * \brief       MSG_Free
 *
 * \detail      Deallocate memory
 *
 * \return      
 *
 * \retval      
 *
 * \param *msg 
 */
void MSG_Free(void *msg)
{
#if defined (OS_NUCLEUS)
  if (NU_Deallocate_Memory(msg) != NU_SUCCESS)
  {
    /// \todo - Handle the error correctly over here
    DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Could not free memory\r\n");
    DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
#elif defined (OS_WINCE)
  // Function returns NULL if it could successfully free the memory.
  if (NULL != LocalFree(msg))
  {
	/// \todo - Handle the error correctly over here
	DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_Free: Could not free memory");
    DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
  }
#endif
	if (OsFreeMemory(msg))
	{
		/// \todo - Handle the error correctly over here
		DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_Free: Could not free memory");
		DmConsolePrintError(DM_ERROR_LEVEL_FATAL, 0, 0, 0);
	}
}



/**
 *
 * \date        04-26-2007
 *
 * \author      mtalreja
 *
 * \brief       MSG_Queue
 *
 * \detail      Detailed description
 *
 * \return      What is returned
 *
 * \retval      
 *
 * \param pipe 
 * \param msg 
 * \param size 
 */
#if defined (OS_NUCLEUS)
void MSG_Queue(NU_PIPE * pipe, void * msg, UINT32 size)
#elif defined (OS_WINCE)
void MSG_Queue(HANDLE pipe, void * msg, UINT32 size)
#endif
void MSG_Queue(DM_RESOURCE_HANDLE pipe, void *msg, UINT32 size)
{
#if defined (OS_NUCLEUS)
  NU_Send_To_Pipe(pipe, msg, size, NU_NO_SUSPEND);
#elif defined (OS_WINCE)
  if (TRUE != WriteMsgQueue(pipe, msg, size, OS_NO_SUSPEND, 0))
  {
	  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_Queue: Write failed: %d", GetLastError());
  }
#endif
  INT32 bytesQueued = OsQueueBytes(pipe, msg, size);
  if(bytesQueued < size) {
      DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_Queue: Write failed: %li", bytesQueued);
  }
  // Figure out which pipe is being written to and set the correct event
  // flag because that's how the application will read the queues.
  // The receive task has a timer running to do this anyways - taking
  // this code out
#if 0
 #if defined (OS_NUCLEUS)
  if (pipe == &mMlmeNwkInputQueue)
  {
  } // if (pipe == &mMlmeNwkInputQueue)
  else if (pipe == &mMcpsNwkInputQueue)
  {
  } // if (pipe == &mMcpsNwkInputQueue)
  else if (pipe == &mAspNwkInputQueue)
  {
  } // if (pipe == &mAspNwkInputQueue)
 #elif defined (OS_WINCE)
	// TO DO - need to check the correct pipe pointers.
 #endif
#endif // disable setting event flags to indicate there is data in the pipes
}

/**
 *
 * \date        04-26-2007
 *
 * \author      pmadhur
 *
 * \brief       MSG_InitQueue
 *
 * \detail      Can not directly reset pipe in WINCE.
 *
 * \return      What is returned
 *
 * \retval      
 *
 * \param pipe 
 * \param msg 
 * \param size 
 */
#if defined (OS_WINCE)
void MSG_InitQueue(HANDLE pipe)
{
	static BOOL bAllocateMemory = FALSE;
	HANDLE hLocalMem;
	DWORD dwMsgLen, dwFlags;

	// Allocate memory for the read buffer only once.
	if (bAllocateMemory == FALSE)
	{
		// The size is taken from MSG_DeQueue function, to read the messages for all the 3 pipes.
		//hLocalMem = (void *)HeapAlloc(hprSystemMemoryPool, LMEM_FIXED, (sizeof(toFromNwkMessage_t) + SMAC_MAXPACKETSIZE));
		hLocalMem = LocalAlloc(LPTR, (sizeof(toFromNwkMessage_t) + SMAC_MAXPACKETSIZE));
		if (hLocalMem == NULL)
		{
			// Hopefully this won't happen!!
			DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "MSG_InitQueue: Could not allocate memory\r\n");
			DmConsolePrintError (DM_ERROR_LEVEL_FATAL, 0, 0, 0);
		}
		bAllocateMemory = TRUE;
	}
	// size should be same as that of the buffer passed in the second parameter> Otherwise we get error.
	// Keep reading until all the messages are finished.
	// When there are no messages, it will return 0, with GetErrorState as ERROR_TIMEOUT
	while (ReadMsgQueue(pipe, (void *) hLocalMem, (sizeof(toFromNwkMessage_t) + SMAC_MAXPACKETSIZE), &dwMsgLen, OS_NO_SUSPEND, &dwFlags)); 
}
#endif







/**
 *
 * \date        04-26-2007
 *
 * \author      mtalreja
 *
 * \brief       NWK_MLME_SapHandler
 *
 * \detail      This handles the mlme primitives from the RF application to
 *              the 802.15.4 simulation layer. This function will deallocate
 *              messages passed in unless it is a Get, set or a reset request.
 *              Make sure that every path the code takes frees up the memory.
 *              i.e. Don't return from any case statements!!!!!!
 *              
 * \return      Status
 *
 * \retval      
 *
 * \param *pMsg pMsg must be allocated by MSG_Alloc(size) unless the primitive in question
 *              is Get/Set/Reset-Request.
 * \return 
 */
uint8_t NWK_MLME_SapHandler(mlmeMessage_t *pMsg)
{
  uint8_t retval = gSuccess_c;
  nwkMessage_t nwkMessage;
  mlmeStartReq_t *pStartReq;
  UINT16 pan_id;
  uint8_t status = gSuccess_c;
  BOOL doNotFreeMsg = FALSE;

  // Handle whatever messages we can. We return from PIB GET and SET right away
  // Others are just ignored for now
  switch(pMsg->msgType)
  {
    case gMlmeGetReq_c:
      /// \todo Handle the get request here
      doNotFreeMsg = TRUE;
      break;

    case gMlmeResetReq_c:
      /// \todo Handle the reset request here
      // MNT - 5/14/2007 - For now we will just set the SMAC state machines to go back to receive mode
      // This should effectively drop the packet. If we need to reset the phy, this code needs to change
      // to go to the RESET state in the SMAC state machine
      // MNT - 6/13/2007 - For now if RF is disabled, stay disabled till enabled
      if (Rf_Smac_802_PIB.rfDisabled == FALSE)
      {
        SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_APP_REQ_SMAC_RST);
        SMAC_SM_ResetPhy_And_Nack();
      } // if (Rf_Smac_802_PIB.rfDisabled == FALSE)


      doNotFreeMsg = TRUE;
      break;

    case gMlmeSetReq_c:
      retval = MLME_Set_Pib_Attribute(pMsg->msgData.setReq.pibAttribute, pMsg->msgData.setReq.pibAttributeValue);
      doNotFreeMsg = TRUE;
      break;

    case gMlmeStartReq_c:
      // Check the parameters passed. If they don't match the PIB database, set them
      // and return a success response. The portion before sending the response can be
      // split into a separate function if needed
	    pStartReq = &pMsg->msgData.startReq;      
      
      // Check if the short address has been set.
      if ((Rf_Smac_802_PIB.shortAddress == 0) || (Rf_Smac_802_PIB.shortAddress == 0xFFFF))
      {
        status = gNoShortAddress_c;
        nwkMessage.msgType = gNwkStartCnf_c;
        nwkMessage.msgData.startCnf.status = status;
#if defined (OS_NUCLEUS)
		MSG_Queue(&Rf_Smac_Shim.MlmeNwkInputQueue, &nwkMessage, sizeof(nwkStartCnf_t));
#elif defined (OS_WINCE)
		MSG_Queue(&Rf_Smac_Shim.hWriteMlmeNwkInputQueue, &nwkMessage, sizeof(nwkStartCnf_t));
#endif
        HPRF_QUEUE_DEBUG(DmConsolePrintf("*** %s:%i ---> queueing packet size %lu to mlmeNwkInputQueue\n", \
                  __FUNCTION__, __LINE__, sizeof(nwkStartCnf_t));)
		MSG_Queue(Rf_Smac_Shim.hMlmeNwkInputQueue, &nwkMessage, sizeof(nwkStartCnf_t));
        break;
      }

      // Set the Logical Channel
      if (pStartReq->logicalChannel != Rf_Smac_802_PIB.logicalChannel)
      {
        MLME_Set_Pib_Attribute(gMPibLogicalChannel_c, (UINT8*)&pStartReq->logicalChannel);
      } //if (pStartReq->logicalChannel != Rf_Smac_802_PIB.logicalChannel)

      // Set the PAN ID
      pan_id = ( pStartReq->panId[1] | (pStartReq->panId[0] << 8));
      if (Rf_Smac_802_PIB.panId !=  pan_id)
      {
        MLME_Set_Pib_Attribute(gMPibPanId_c, (UINT8*)&pan_id);
      }

      // Now, just send a success response
      nwkMessage.msgType = gNwkStartCnf_c;
      nwkMessage.msgData.startCnf.status = status;
#if defined (OS_NUCLEUS)      
	  MSG_Queue(&Rf_Smac_Shim.MlmeNwkInputQueue, &nwkMessage, sizeof(nwkStartCnf_t));
#elif defined (OS_WINCE)
	  MSG_Queue(&Rf_Smac_Shim.hWriteMlmeNwkInputQueue, &nwkMessage, sizeof(nwkStartCnf_t));
#endif
	  HPRF_QUEUE_DEBUG(DmConsolePrintf("*** %s:%i ---> queueing packet size %lu to mlmeNwkInputQueue\n", \
	          __FUNCTION__, __LINE__, sizeof(nwkStartCnf_t));)
	  MSG_Queue(Rf_Smac_Shim.hMlmeNwkInputQueue, &nwkMessage, sizeof(nwkStartCnf_t));
      break;

    default:
      /// \review - Is this the right return value
      retval = gInvalidParameter_c;
      
      /// \review - Since this is a message other than get, set or reset
      break;

  } // switch(pMsg->msgType)

  // - Free the message if not a SET/GET or RESET Request 

  if (doNotFreeMsg == FALSE)
  {
    MSG_Free(pMsg);
  }


  return retval;
  
}






/**
 *
 * \date        04-26-2007
 *
 * \author      mtalreja
 *
 * \brief       MLME_Set_Pib_Attribute
 *
 * \detail      Set the MAC PIB attribute
 *
 * \return      gSuccess_c  - Success
 *              gUnsupportedAttribute_c  - If we don't support the attribute
 *
 * \retval      
 *
 * \param pibAttribute        One value from the MAC PIB attributes
 * \param *pibAttributeValue  Value of the attribute
 * \return 
 */
UINT8 MLME_Set_Pib_Attribute(uint8_t  pibAttribute, uint8_t  *pibAttributeValue)
{
  UINT8   retval = gSuccess_c;
  UINT8   val_8bit = 0;
  UINT16  val_16bit = 0;


  // only process attributes that we understand otherwise return gUnsupportedAttribute_c

  switch (pibAttribute)
  {
    case gMPibLogicalChannel_c:
      val_8bit = *pibAttributeValue;
      // The logical channel number is from 11 to 26 - we need to subtract 11 from
      // the logical channel for the physical channel.
      PLMESetChannelRequest(val_8bit - 11);
      Rf_Smac_802_PIB.logicalChannel = val_8bit;
      break;

    case gMPibRxOnWhenIdle_c:
      val_8bit = *pibAttributeValue;
      Rf_Smac_802_PIB.isRxOnWhenIdle = val_8bit;
      break;

    case gMPibPanId_c:
      val_16bit = *((UINT16 *)pibAttributeValue);
      Rf_Smac_802_PIB.panId = val_16bit;
      break;

    case gMPibShortAddress_c:
      val_16bit = *((UINT16 *)pibAttributeValue);
      Rf_Smac_802_PIB.shortAddress = val_16bit;
      break;
    
    case gMPibCoordShortAddress_c:
      val_16bit = *((UINT16 *)pibAttributeValue);
      Rf_Smac_802_PIB.coordShortAddress = val_16bit;
      break;

    case gMPibCoordExtendedAddress_c:
      memcpy(&Rf_Smac_802_PIB.coordExtendedAddress, pibAttributeValue, sizeof(Rf_Smac_802_PIB.coordExtendedAddress));
      break;

    case gMPibAssociationPermit_c:
      val_8bit = *pibAttributeValue;
      Rf_Smac_802_PIB.shouldPermitAssociate = val_8bit;
      break;

    case gMPibPromiscuousMode_c:
      val_8bit = *pibAttributeValue;
      Rf_Smac_802_PIB.promiscuousMode = val_8bit;
      break;

    default:
      retval = gUnsupportedAttribute_c;
      break;
  
  } // switch (pibAttribute)


  
  return retval;
}





/**
 *
 * \date        05-04-2007
 *
 * \author      mtalreja
 *
 * \brief       SetFrameCtlDefaults
 *
 * \detail      Inline function to set the frame control defaults. For some reason
 *              the frame control bits were getting corrupt
 *
 * \return      Nothing
 *
 * \retval      
 *
 * \param *frmCtl 
 */
#if defined (OS_NUCLEUS)
 #pragma inline SetFrameCtlDefaults
void SetFrameCtlDefaults(Rf_802_15_MAC_Data_FrameCtlField_struct *frmCtl)
#elif defined (OS_WINCE)
__inline void SetFrameCtlDefaults(Rf_802_15_MAC_Data_FrameCtlField_struct *frmCtl)
#endif
inline void SetFrameCtlDefaults(Rf_802_15_MAC_Data_FrameCtlField_struct *frmCtl)
{
      frmCtl->ackRequest = 1;
      frmCtl->frameType = RF_802_15_MAC_FC_FRTYPE_DATA;
      frmCtl->destAddrMode = RF_802_15_MAC_FC_ADDRMODE_EXT;
      frmCtl->srcAddrMode  = RF_802_15_MAC_FC_ADDRMODE_EXT;

      frmCtl->framePending  = 0;
      frmCtl->frameVersion = 0;
      frmCtl->panIDCompression = 0;
      frmCtl->reserved = 0;
      frmCtl->securityEnabled = 0;
}






/**
 *
 * \date        04-27-2007
 *
 * \author      mtalreja
 *
 * \brief       NWK_MCPS_SapHandler
 *
 * \detail      This handles the data primitives from the RF application to
 *              the 802.15.4 simulation layer. This function will deallocate
 *              messages passed in unless it is a Get, set or a reset request.
 *              Make sure that every path the code takes frees up the memory.
 *              i.e. Don't return from any case statements!!!!!!
 *
 * \return      What is returned
 *
 * \retval      
 *
 * \param *pMsg 
 * \return 
 */
uint8_t NWK_MCPS_SapHandler(nwkToMcpsMessage_t *pMsg)
{
  uint8_t retval = gSuccess_c;
	mcpsDataReq_t *pPacket;
  mcpsToNwkMessage_t dataConfMsg;
  //mcpsDataCnf_t dataConfMsg;
  Rf_802_15_MAC_TO_SMAC_Frame_struct txFrame;
  Rf_802_15_MAC_Data_FrameCtlField_struct frmCtl;
  UINT16 tempFrameCtl;
  size_t numBytes = 0;
#if defined (OS_NUCLEUS)
  STATUS status;
#endif
  INT32 status;

  switch(pMsg->msgType)
  {
    case gMcpsDataReq_c:

      // Break this up into a separate function if necessary

      if (Rf_Smac_802_PIB.rfDisabled == TRUE)
      {
        // Just discard the message here - we are in telec test mode
        break;
      } // if (Rf_Smac_802_PIB.rfDisabled == TRUE)


      // Format the message correctly to be sent via RF
      pPacket = &pMsg->msgData.dataReq;


      // Do error checks
      if (pPacket->msduLength > RF_802_15_MAC_DATA_MAX_SIZE)
      {
        // If data is too big, just return a frame too long message
        dataConfMsg.msgType = gMcpsDataCnf_c;
        dataConfMsg.msgData.dataCnf.msduHandle = pPacket->msduHandle;
        dataConfMsg.msgData.dataCnf.status     = gFrameTooLong_c;
#if defined (OS_NUCLEUS)
		MSG_Queue(&Rf_Smac_Shim.McpsNwkInputQueue, &dataConfMsg, sizeof(dataConfMsg));
#elif defined (OS_WINCE)
		MSG_Queue(Rf_Smac_Shim.hWriteMcpsNwkInputQueue, &dataConfMsg, sizeof(dataConfMsg));
#endif
		HPRF_QUEUE_DEBUG(DmConsolePrintf("*** %s:%i ---> queueing packet size %lu to mcpsNwkInputQueue\n", \
	              __FUNCTION__, __LINE__, sizeof(dataConfMsg));)
		MSG_Queue(Rf_Smac_Shim.hMcpsNwkInputQueue, &dataConfMsg, sizeof(dataConfMsg));
        break;
      } // if (pPacket->msduLength > RF_802_15_MAC_DATA_MAX_SIZE)

      //Construct a MAC Frame and send it to the TX Queue
      memcpy(&txFrame.RfData.header.dstAddr,  &pPacket->dstAddr,  sizeof(txFrame.RfData.header.dstAddr));
      memcpy(&txFrame.RfData.header.dstPanId, &pPacket->dstPanId, sizeof(txFrame.RfData.header.dstPanId));
      memcpy(&txFrame.RfData.header.srcAddr,  &pPacket->srcAddr,  sizeof(txFrame.RfData.header.srcAddr));
      memcpy(&txFrame.RfData.header.srcPanId, &pPacket->srcPanId, sizeof(txFrame.RfData.header.srcPanId));
      SetFrameCtlDefaults(&frmCtl);
      txFrame.RfData.header.frameCtl = frmCtl;
      memcpy(&txFrame.RfData.data, &pPacket->msdu, pPacket->msduLength);
      txFrame.msduHandle = pPacket->msduHandle;

      // Always add one byte to the transmission because the top of every frame that
      // goes to the smac has an msdu handle
#if defined (OS_NUCLEUS)
      status = NU_Send_To_Pipe(&TxRxTask.toRFPipe, 
                        &txFrame, 
                        pPacket->msduLength + sizeof(txFrame.RfData.header) + sizeof(txFrame.msduHandle), 
                        NU_NO_SUSPEND) ;
      if(status != NU_SUCCESS)
#elif defined (OS_WINCE)
	  if (TRUE != WriteMsgQueue(TxRxTask.hWriteHandleToRFPipe, (void*)&txFrame, (pPacket->msduLength + sizeof(txFrame.RfData.header) + sizeof(txFrame.msduHandle)), OS_NO_SUSPEND, 0))
#endif
	  numBytes = (pPacket->msduLength + sizeof(txFrame.RfData.header) + sizeof(txFrame.msduHandle));
      status = OsQueueBytes(TxRxTask.hHandleToRFPipe, (void*)&txFrame, numBytes);
      HPRF_QUEUE_DEBUG(DmConsolePrintf("*** %s:%i ---> queued %li bytes to ToRFPipe\n", \
              __FUNCTION__, __LINE__, status);)
      HPRF_DEBUG(print_hex_dump(KERN_INFO, "shim queue ", DUMP_PREFIX_ADDRESS, \
            16, 1, &txFrame, numBytes, true);)

      if(status <= 0)
      {
        /// \todo Handle the error condition appropriately
#if defined (OS_NUCLEUS)
		  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "NWK_MCPS: Cannot send data to tx pipe: 0x%x\r\n", status);
#elif defined (OS_WINCE)
		  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "NWK_MCPS: Cannot send data to tx pipe: 0x%x", GetLastError());
#endif
		  DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "NWK_MCPS: Cannot send data to tx pipe: %li\r\n", status);

        /// \review What error code to return here
          retval = 0xFF;
          break;
      } // if(NU_Send_To_Pipe(&TxRxTask.toRFPipe, txFrame, sizeof(txFrame), NU_NO_SUSPEND) != NU_SUCCESS)

      SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_MCPS_TXPKT);
#if defined (OS_NUCLEUS)
      NU_Set_Events(&TxRxTask.events, RF_TRX_TX_PACKET, NU_OR);
#elif defined (OS_WINCE)
		SetEvent(TxRxTask.hEvents[RF_TRX_TX_PACKET]);
#endif
	  OsSetEvent(TxRxTask.events, RF_TRX_TX_PACKET);
      break;


    case gMcpsPurgeReq_c:
      break;
  } // switch(pMsg->msgType)


  // Free the message before leaving
  MSG_Free(pMsg);

  return retval;

}






#if 0

////////
// Test Functions
////////
/**
 *
 * \date        04-26-2007
 *
 * \author      mtalreja
 *
 * \brief       SetPIBAttCmd
 *
 * \detail      This is just for test - this should absolutely not be used under
 *              any circumstances later on - remove it after test is done
 *
 * \return      What is returned
 *
 * \retval      
 *
 * \param ignore 
 * \param *cmd 
 * \return 
 */
int SetPIBAttCmd (int ignore, char *cmd)
{
  UINT8 attribute=0;
  UINT16 attributeValue=0;
	mlmeMessage_t *Msg;
	mlmeMessage_t setMsg;
  mlmeStartReq_t *pStartReq;

  char *p ;
	char   *endptr;

    if ( *cmd == '?')                   // print help string
    {
        ConsoleWriteData("SETPIBATT attribute value\r\n");
        ConsoleWriteData("\attribute -  attribute number in hex\r\n");
        ConsoleWriteData("\value     -  attribute value in hex\r\n");
        return 0;
    } // if ( *cmd == '?')                   // print help string

    if ( !(*cmd) )                 // print current status
    {
        ConsoleWriteData("Please enter an attribute in hex as a parameter\r\n");
        return 0;
    } // if ( !(*cmd) )                 // print current status

    p = strtok(cmd," -.,;:") ;
    if ( !p )
        return -1;

    attribute = (UINT8)strtoul(p, &endptr, 16);

    p = strtok(NULL," -.,;:") ;
    if ( !p )
        return -1;
    
    attributeValue = (UINT16)strtoul(p, &endptr, 16);

    Msg = MSG_Alloc(sizeof(mlmeStartReq_t));
    // First send the start MLME-START.req command
	    Msg->msgType = gMlmeStartReq_c;	    
	    /* Create the Start request message data. */
	    pStartReq = &Msg->msgData.startReq;
	    /* PAN ID - LSB, MSB (little indian). The example shows a PAN ID of 0xFEED. */
	    pStartReq->panId[0]	= (0xFEED)%256;
		  pStartReq->panId[1] = (0xFEED)/256;
	    /* Logical Channel - the default of 11 will be overridden */
	    pStartReq->logicalChannel = 26;
	    /* Beacon Order - 0xF = turn off beacons */
	    pStartReq->beaconOrder = 0x0F;  
	    /* Superframe Order - 0xF = turn off beacons */
	    pStartReq->superFrameOrder = 0x0F;
		/* Be a PAN coordinator */
	    pStartReq->panCoordinator = TRUE;
		/* Don't use battery life extension */
	    pStartReq->batteryLifeExt = FALSE;
	    /* This is not a Realignment command */
	    pStartReq->coordRealignment = FALSE;
	    /* Dont use security */
	    pStartReq->securityEnable = FALSE;	    
	    /* Send the Start request to the MLME. */
	    if(MSG_Send(NWK_MLME, Msg) != gSuccess_c)	
      {	      	
			/* One or more parameters in the Start Request message were invalid. */
		    ErrorHandler("Failed starting of PAN\r\n");
			}




    setMsg.msgType = gMlmeSetReq_c;
	  setMsg.msgData.setReq.pibAttribute      = attribute;
	  setMsg.msgData.setReq.pibAttributeValue = (UINT8 *)&attributeValue;

	  if(MSG_Send(NWK_MLME, (mlmeMessage_t*) &setMsg) != gSuccess_c)	
    {	
		  ErrorHandler("Failure\r\n");
    } // msgsend



	


    DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "Wrote Value 0x%08x = 0x%08x", attribute, attributeValue);
    return 0;  

}

#endif




/**
 *
 * \date        05-07-2007
 *
 * \author      mtalreja
 *
 * \brief       APP_ASP_SapHandler
 *
 * \detail      Handle PHY Messages
 *
 * \return      All messages here should be synchronous. Nothing
 *              should really go to the incoming pipe. 
 * \review      Should we eliminate the incoming pipe for ASP messages
 *
 * \retval      
 *
 * \param *pMsg 
 * \return 
 */
uint8_t APP_ASP_SapHandler(aspMsg_t *pMsg)
{
  uint8_t retval = gSuccess_c;
  aspSetPowerLevelReq_t * setPowReq;
  aspTelecSetChannelReq_t * telecSetChanReq;
  aspTelecTestReq_t * telecTestReq;
  tTxPacket testPacket;  // dummy packet needed in case of PRBS9 mode
  UINT8 TxDataBuffer[128];
  BOOL shouldIdleFirst = FALSE;

  testPacket.pu8Data = TxDataBuffer;

  switch(pMsg->msgType)
  {

    case gAppAspSetPowerLevelReq_c:
      setPowReq = (aspSetPowerLevelReq_t *)(&pMsg->appToAspMsg.msgData.aspSetPowerLevelReq);
      Rf_Smac_802_PHYParams.outputPower = setPowReq->powerLevel;
      MLMEMC13192PAOutputAdjust(setPowReq->powerLevel);	//Set power setting	
      break;

    case gAppAspTelecSetChannelReq_c:
      telecSetChanReq = (aspTelecSetChannelReq_t *)(&pMsg->appToAspMsg.msgData.aspTelecSetChannelReq);
      Rf_Smac_802_PIB.logicalChannel = telecSetChanReq->logicalChannel;
      (void)MLMESetChannelRequest(telecSetChanReq->logicalChannel-11);	//Set channel zero, can be changed to users preference
      break;

    case gAppAspTelecTestReq_c:


      // MNT - 7/30/2007 - Send a reset down - the phy gets into a funky mode if this is not
      // done
      SMAC_SM_ResetPhy_And_Nack();

      // MNT - 6/13/2007 - Disable RF Transmissions and reception
      // Before doing anything, check to see if we are already testing something. Go to idle
      // mode first - the stack does not like it if you don't do this.
      HwDelayMsec(10);

      if (!Smac_isResetDone())
      {
        DmConsoleLevelPrintf(DM_ERROR_LEVEL_ERROR, "APP_ASP_SapHandler: Telec test could not reset the phy\r\n");
        return gDisableTrxFailure_c;
      }//if (Smac_ResetDoneFlag == FALSE)

      if (Rf_Smac_802_PIB.rfDisabled == TRUE)
      {
        shouldIdleFirst = TRUE;
      }
      else
      {
        shouldIdleFirst = FALSE;
      }
      Rf_Smac_802_PIB.rfDisabled = TRUE;
      gi8AppStatus = IDLE_STATE;
      SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_TELEC_START);
#if defined (OS_NUCLEUS)
      NU_Set_Events(&TxRxTask.events, RF_TRX_RX_ON, NU_OR);
#elif defined (OS_WINCE)
	  SetEvent(TxRxTask.hEvents[RF_TRX_RX_ON]);
#endif
	  OsSetEvent(TxRxTask.events, RF_TRX_RX_ON);
     
      // Before doing anything, check to see if we are already testing something. Go to idle
      // mode first - the stack does not like it if you don't do this.
      if (shouldIdleFirst == TRUE)
      {
        if (MLMETestMode(&testPacket, FORCE_IDLE) == SMAC_FAILURE)
        {
          retval = gDisableTrxFailure_c;
        } 
        HwDelayMsec(10);
       }

      telecTestReq = (aspTelecTestReq_t *)(&pMsg->appToAspMsg.msgData.aspTelecTestReq);
      // MNT - 6/12/07 - Freescale modes don't match the SMAC modes (of course) - Do the translation here
      // Using if statements instead of switch because I'm not sure if the compiler will behave well with
      // nested switch statements.
      if (telecTestReq->mode == gTestForceIdle_c)
      {
        if (MLMETestMode(&testPacket, FORCE_IDLE) == SMAC_FAILURE)
        {
          retval = gDisableTrxFailure_c;
        } // test mode failure

#if 0
        Rf_Smac_802_PIB.rfDisabled = FALSE;
        SMAC_SET_APP_STATE(RECEIVER_ALWAYS_ON);
        SMAC_LOG_DEBUG_STATE (gi8AppStatus, SMAC_SM_DEBUG_EVENT_TELEC_DONE);
#if defined (OS_NUCLEUS)
      NU_Set_Events(&TxRxTask.events, RF_TRX_RX_ON, NU_OR);
#elif defined (OS_WINCE)
	  SetEvent(TxRxTask.hEvents[RF_TRX_RX_ON]);
#endif
#endif // if 0 - once in telec mode, stay in telec mode. You have to reboot 

      } //if (telecTestReq->mode == gTestForceIdle_c)
      else if (telecTestReq->mode == gTestPulseTxPrbs9_c)
      {

        if (MLMETestMode(&testPacket, PULSE_TX_PRBS9) == SMAC_FAILURE)
        {
          retval = gDisableTrxFailure_c;
        } // test mode failure

      } //if (telecTestReq->mode == gTestPulseTxPrbs9_c)
      else if (telecTestReq->mode == gTestContinuousRx_c)
      {

        if (MLMETestMode(&testPacket, CONTINUOUS_RX) == SMAC_FAILURE)
        {
          retval = gDisableTrxFailure_c;
        } // test mode failure

      } //if (telecTestReq->mode == gTestContinuousRx_c)
      else if (telecTestReq->mode == gTestContinuousTxMod_c)
      {

        if (MLMETestMode(&testPacket, CONTINUOUS_TX_MOD) == SMAC_FAILURE)
        {
          retval = gDisableTrxFailure_c;
        } // test mode failure

      } //if (telecTestReq->mode == gTestContinuousTxMod_c)
      else if (telecTestReq->mode == gTestContinuousTxNoMod_c)
      {

        if (MLMETestMode(&testPacket, CONTINUOUS_TX_NOMOD) == SMAC_FAILURE)
        {
          retval = gDisableTrxFailure_c;
        } // test mode failure

      } //if (telecTestReq->mode == gTestContinuousTxNoMod_c)
      else
      {
        retval = gInvalidParameter_c;
      } //if (telecTestReq->mode == gTestForceIdle_c)


      break;

    default:
      retval = gInvalidParameter_c;
      break;
  } // switch(pMsg->msgType)


  return retval;

}
